(function ($) {
    'use strict';
    var VisualParticlesWaveAnimation = {
        initParticlesWave: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualParticlesWaveAnimation.initParticlesWaveWidget);
        },
        initParticlesWaveWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var particlesWaveAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        particlesWaveAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                particlesWaveAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    if (particlesWaveAnimationArgs.marvy_enable_particles_wave_animation) {
                        settings.switch = particlesWaveAnimationArgs.marvy_enable_particles_wave_animation;
                        settings.particle_count = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_count;
                        settings.partical_size = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_size;
                        settings.speed = particlesWaveAnimationArgs.marvy_particles_wave_animation_animation_speed;
                        settings.color = particlesWaveAnimationArgs.marvy_particles_wave_animation_particle_color;
                        settings.default_background = particlesWaveAnimationArgs.marvy_enable_particles_wave_animation_default_background;
                    }
                });

            } else {
                settings.switch = $scope.data("marvy_enable_particles_wave_animation");
                settings.particle_count = $scope.data("marvy_particles_wave_animation_particle_count");
                settings.partical_size = $scope.data("marvy_particles_wave_animation_particle_size");
                settings.speed = $scope.data("marvy_particles_wave_animation_animation_speed");
                settings.color = $scope.data("marvy_particles_wave_animation_particle_color");
                settings.default_background = $scope.data("marvy_enable_particles_wave_animation_default_background");
            }
            if (settings.switch) {
                particlesWaveAnimation(target, settings, sectionId);
            }else {
                document.querySelector(target).classList.remove("marvy-custom-particles-wave-animation");
                document.querySelector(target).classList.remove("with-default-background");
            }
        }
    };

    function particlesWaveAnimation(target, settings, sectionId) {
        var checkElement = document.getElementsByClassName("marvy-particles-wave-section-" + sectionId);
        if (checkElement.length >= 0 && settings) {
            document.querySelector(target).classList.add("marvy-custom-particles-wave-animation-section-" + sectionId);
            document.querySelector(target).classList.add("marvy-custom-particles-wave-animation");
            document.querySelector(target).classList.add("with-default-background");
            if(settings.default_background != 'yes'){
                document.querySelector(target).classList.remove("with-default-background");
            }
            var particles_wave_div = document.createElement('canvas');
            particles_wave_div.setAttribute('id', 'marvy-particle-wave-canvas-' + sectionId);
            particles_wave_div.classList.add("marvy-particles-wave-section-" + sectionId);
            particles_wave_div.classList.add("marvy-particles-wave");
            document.querySelector(target).appendChild(particles_wave_div);

            // Set Z-index for section container
            var particlesWaveZindex = document.querySelector('.marvy-custom-particles-wave-animation-section-' + sectionId + ' .elementor-container');
            particlesWaveZindex.style.zIndex = '99';
            particlesWaveZindex.style.width = '100%';

            settings.speed = settings.speed * 100;

            startAnimation('marvy-particle-wave-canvas-' + sectionId, settings.particle_count, settings.partical_size, settings.speed,settings.color);
            resizeCanvas(sectionId);
        }
        return true;
    }

    function resizeCanvas(id){
        var canvas = document.getElementById('marvy-particle-wave-canvas-'+id);
        if (canvas) {
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
        }
    }

    $(window).on('resize', function(){
        resizeCanvas();
    });
    $(window).on('elementor/frontend/init', VisualParticlesWaveAnimation.initParticlesWave);
})(jQuery);
